﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

public class SpawnEnemies : MonoBehaviour {

    public GameObject[] enemies;
    public Transform spawnPoint;
    public int spawnCount;

    public float startTime, waveTime, spawnTime;

    private float min = 1.09f;
    private float max = 2.8f;

    void Start () {
        StartCoroutine(SpawnEnemy());
	}
	
	void Update () {
		
	}

    IEnumerator SpawnEnemy()
    {
        yield return new WaitForSeconds(startTime);
        while (true)
        {
            for (int i = 0; i < spawnCount; i++)
            {
                transform.position = new Vector3(spawnPoint.position.x, Random.Range(min, max), spawnPoint.position.y);
                Quaternion spawnRotation = Quaternion.identity;
                int randomNumber = Random.Range(0, 2);

                Instantiate(enemies[randomNumber], transform.position, spawnRotation);

                yield return new WaitForSeconds(spawnTime);
            }

            yield return new WaitForSeconds(waveTime);
        }
    }
}
